#ifndef _ROCKEY2_H__
#define _ROCKEY2_H__
#define R2_MINOR        16      /* the max number of rockey2 device */

#define AUTO_MODE	    0
#define HID_MODE	    -1

#define ROCKEY2_DISABLE_WRITE_PROTECT	0
#define ROCKEY2_ENSABLE_WRITE_PROTECT	1

#define DWORD	        unsigned long
#define WORD		    unsigned short
#define BYTE            char


#define RY2ERR_SUCCESS					            0
#define RY2ERR_NO_SUCH_DEVICE				        0xA0100001
#define RY2ERR_NOT_OPENED_DEVICE			        0xA0100002
#define RY2ERR_WRONG_UID				            0xA0100003
#define RY2ERR_WRONG_INDEX				            0xA0100004
#define RY2ERR_TOO_LONG_SEED				        0xA0100005
#define RY2ERR_WRITE_PROTECT				        0xA0100006
#define RY2ERR_OPEN_DEVICE				            0xA0100007
#define RY2ERR_READ_REPORT				            0xA0100008
#define RY2ERR_WRITE_REPORT				            0xA0100009
#define RY2ERR_SETUP_DI_GET_DEVICE_INTERFACE_DETAIL	0xA010000A
#define RY2ERR_GET_ATTRIBUTES				        0xA010000B
#define RY2ERR_GET_PREPARSED_DATA			        0xA010000C
#define RY2ERR_GETCAPS					            0xA010000D
#define RY2ERR_FREE_PREPARSED_DATA			        0xA010000E
#define RY2ERR_FLUSH_QUEUE				            0xA010000F
#define RY2ERR_SETUP_DI_CLASS_DEVS			        0xA0100010
#define RY2ERR_GET_SERIAL				            0xA0100011
#define RY2ERR_TOO_LONG_DEVICE_DETAIL			    0xA0100012
#define RY2ERR_WRONG_REPORT_LENGTH			        0xA0100013
#define RY2ERR_VERIFY					            0xA0100014
#define RY2ERR_UNKNOWN_ERROR				        0xA010FFFF


/* the api for client use */
#ifdef __cplusplus
extern "C" {
#endif
/*
int RY2_Find();
int RY2_Open(int mode, DWORD uid, DWORD *hid);
void RY2_Close(int handle);
int RY2_GenUID(int handle, DWORD *uid, char *seed, int isProtect);
int RY2_Read(int handle, int block_index, char *buffer512);
int RY2_Write(int handle, int block_index, char *buffer512);
int RY2_Transform(int handle, int len, char *data);
*/
typedef int (*FindPtr)();
typedef int (*OpenPtr)(int mode, DWORD uid, DWORD *hid);
typedef void (*ClosePtr)(int handle);
typedef int (*GenUIDPtr)(int handle, DWORD *uid, char *seed, int isProtect);
typedef int (*ReadPtr)(int handle, int block_index, char *buffer512);
typedef int (*WritePtr)(int handle, int block_index, char *buffer512);
typedef int (*TramsformPtr)(int handle, int len, char *data);

CFBundleRef Initialize(CFBundleRef theBundle, FindPtr *find, 
						OpenPtr *open, ClosePtr *close, GenUIDPtr *genUID, 
						ReadPtr *read, WritePtr *write, TramsformPtr *tramsform);

void Uninitialize(CFBundleRef theBundle);

#ifdef __cplusplus
}
#endif

#endif


