#include <stdio.h>
#include <string.h>
#include "rockey2.h"

int main()
{
	int retcode, handle, block_index;
	DWORD uid, hid;
	char buffer[513] = {0};
	printf("\n");
	printf("..........................generate UID.........................\n");
	printf("...............................................................\n");

	printf("Find rockey2...............................\n");
	retcode = RY2_Find();
	if (retcode < 0)
	{
		printf("ERROR of find: %08x\n", retcode);
		return 0;
	}
	if (retcode == 0)
	{
		printf("ERROR: Not found any rockey2\n");
		return 0;
	}
	printf("Find rockey2.............................ok\n\n");
	// There must be one dongle pluging in computer when generating UID,so we don't care the UID and
	// HID of it .We only use the first dongle.
	printf("We only use the first rockey2..............\n");
	printf("open the rockey2...........................\n");
	retcode = RY2_Open(AUTO_MODE, 0, &hid);
	if (retcode < 0)
	{
		printf("OPEN ERROR: %08x\n", retcode);
		return 0;
	}
	printf("open the rockey2.........................ok\n\n");
	
	handle = retcode;
	printf("Getuid....................................\n");
	printf("We use the seed = 12345\n");
	printf("Note:The seed code must not be longer than 64bytes!\n");
	strcpy(buffer, "12345");
	retcode = RY2_GenUID(handle, &uid, buffer, ROCKEY2_DISABLE_WRITE_PROTECT);
	if (retcode < 0)
	{
		printf("ERROR: %08x\n", retcode);
		return 0;
	}
	printf("Getuid...................................ok\n");
	printf("UID is %d\n\n", uid);
	printf("close rockey2..............................\n");
	RY2_Close(handle);
	printf("close rockey2............................ok\n\n");

	// after generated new UID, the flag of dongle has changed,you must plug out it and re-plug again
	printf("You must plug out Rockey2 and re-plug to enable new uid.\n\n");

	printf("..............write dongle with appointed UID..................\n");
	printf("...............................................................\n");
	printf("Find rockey2...............................\n");
	retcode = RY2_Find();
	if (retcode < 0)
	{
		printf("ERROR: %08x\n", retcode);
		return 0;
	}
	if (retcode == 0)
	{
		printf("ERROR: Not found any rockey2\n");
		return 0;
	}
	printf("Find rockey2.............................ok\n\n");
	printf("open the rockey2...........................\n");
	retcode = RY2_Open(1, uid, &hid);
	if (retcode < 0)
	{
		printf("ERROR: %08x\n", retcode);
		return 0;
	}
	printf("open the rockey2.........................ok\n\n");

	handle = retcode;
	block_index = 0;
	strcpy(buffer, "0123456789");
	printf("Write string(\"0123456789\") to rockey2......\n");
	printf("Note:The data written to each block must not be longer than 512bytes!\n");
	retcode = RY2_Write(handle, block_index, buffer);
	if (retcode < 0)
	{
		printf("ERROR: %08x\n", retcode);
		return 0;
	}
	printf("Write....................................ok\n\n");
	printf("close rockey2..............................\n");
	RY2_Close(handle);
	printf("close rockey2............................ok\n\n");

	printf("...............read dongle with appointed UID..................\n");
	printf("...............................................................\n");
	printf("Find rockey2...............................\n");
	retcode = RY2_Find();
	if (retcode < 0)
	{
		printf("ERROR: %08x\n", retcode);
		return 0;
	}
	if (retcode == 0)
	{
		printf("ERROR: Not found any rockey2\n");
		return 0;
	}
	printf("Find rockey2.............................ok\n\n");
	printf("open the rockey2...........................\n");
	retcode = RY2_Open(1, uid, &hid);
	if (retcode < 0)
	{
		printf("ERROR: %08x\n", retcode);
		return 0;
	}
	printf("open the rockey2.........................ok\n\n");
	handle = retcode;

	block_index = 0;
	printf("Read data..................................\n");
	retcode = RY2_Read(handle, block_index, buffer);
	if (retcode < 0)
	{
		printf("ERROR: %08x\n", retcode);
		return 0;
	}
	printf("Read data................................ok\n");
	printf("Readed data: %s\n\n", buffer);

	printf("close rockey2..............................\n");
	RY2_Close(handle);
	printf("close rockey2............................ok\n\n");
	
	return 0;
}


