//
// stdint.h
//
//      Copyright (c) Microsoft Corporation. All rights reserved.
//
// The C Standard Library <stdint.h> header.
//
#pragma once
#define _STDINT

#ifndef RC_INVOKED

//#include <vcruntime.h>



// typedef signed char        int8_t;
// typedef unsigned char      uint8_t;
// typedef short              int16_t;
typedef int										int32_t;
typedef unsigned short							uint16_t;
typedef unsigned int							uint32_t;

#if defined(WIN32)
#if _MSC_VER > 1200
typedef long long								int64_t;
typedef unsigned long long						uint64_t;
#else
typedef long int								int64_t;
typedef unsigned long int						uint64_t;
#endif

#elif defined(linux)

#if __WORDSIZE == 64
typedef long int								int64_t;
typedef unsigned long int						uint64_t;
#else
__extension__ typedef long long int				int64_t;
__extension__ typedef unsigned long long int	uint64_t;
#endif

#elif defined(macintosh)

typedef long long								int64_t;
typedef unsigned long long						uint64_t;

#endif

// typedef signed char        int_least8_t;
// typedef short              int_least16_t;
// typedef int                int_least32_t;
// typedef long long          int_least64_t;
// typedef unsigned char      uint_least8_t;
// typedef unsigned short     uint_least16_t;
// typedef unsigned int       uint_least32_t;
// typedef unsigned long long uint_least64_t;

// typedef signed char        int_fast8_t;
// typedef int                int_fast16_t;
// typedef int                int_fast32_t;
// typedef long long          int_fast64_t;
// typedef unsigned char      uint_fast8_t;
// typedef unsigned int       uint_fast16_t;
// typedef unsigned int       uint_fast32_t;
// typedef unsigned long long uint_fast64_t;

// typedef long long          intmax_t;
// typedef unsigned long long uintmax_t;

#endif // RC_INVOKED

/*
 * Copyright (c) 1992-2012 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V6.00:0009 */
