/**
 * \file version.h
 *
 *  Copyright (C) 2011, EnterSafe
 *
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */
#ifndef ES_SSL_VERSION_H
#define ES_SSL_VERSION_H

#include "es_ssl/config.h"

/**
 * The version number x.y.z is split into three parts.
 * Major, Minor, Patchlevel
 */
#define ES_SSL_VERSION_MAJOR  0
#define ES_SSL_VERSION_MINOR  14
#define ES_SSL_VERSION_PATCH  0

/**
 * The single version number has the following structure:
 *    MMNNPP00
 *    Major version | Minor version | Patch version
 */
#define ES_SSL_VERSION_NUMBER         0x000E0000
#define ES_SSL_VERSION_STRING         "0.14.0"
#define ES_SSL_VERSION_STRING_FULL    "ES_SSL 0.14.0"

#if defined(ES_SSL_VERSION_C)

/**
 * Get the version number.
 *
 * @return          The constructed version number in the format
 *                  MMNNPP00 (Major, Minor, Patch).
 */
unsigned int version_get_number();

/**
 * Get the version string ("x.y.z").
 *
 * @param string    The string that will receive the value.
 *                  (Should be at least 9 bytes in size)
 */
void version_get_string( char *string );

/**
 * Get the full version string ("ES_SSL x.y.z").
 *
 * @param string    The string that will receive the value.
 *                  (Should be at least 18 bytes in size)
 */
void version_get_string_full( char *string );

#endif /* ES_SSL_VERSION_C */

#endif /* version.h */
