
#include "Common.h"
#include "es_ssl/havege.h"
#include "es_ssl/rsa.h"
#include "es_ssl/types.h"
#include "es_ssl/cryptoki_ext.h"
#include "baseall.h"


#define  PRIVATE_FILE_LEN 1217

#define  PKCS11_LIB_NAME "eps2003csp11.dll"

void ShowTitle(void)
{
	printf("[]==================================================[]\n");
	printf(" |             USB Token PKCS#11 WrapDemo               |\n");				
	printf("[]==================================================[]\n");
}

int main(int argc, char* argv[])
{
	CK_RV rv = CKR_OK;
	/********************************************************************************************************/
	//initialize pkcs11 dll
	/********************************************************************************************************/

	CP11TestBase testBase(PKCS11_LIB_NAME);
	

	testBase.Initialize();

	/********************************************************************************************************/
	//gen rsa key pairs
	/********************************************************************************************************/

	u4 obj_modulusbits = 1024;
	
	rsa_context rsacontext;
	memset(&rsacontext, 0x00, sizeof(rsa_context));
	havege_state hs;
	havege_init(&hs);
	rsa_gen_key(&rsacontext, havege_rand, &hs, obj_modulusbits, 65537);

	//get N
	u1 data[4096] = {0};
	u4 len=4096;

	u1 dataN[4096] = {0};
	u4 lenN=4096;
	lenN = mpi_size(&rsacontext.N);
	mpi_write_binary(&rsacontext.N, dataN, lenN);

	//get E
	u1 dataE[2048] = {0};
	u4 lenE=4096;
	lenE = mpi_size(&rsacontext.E);
	mpi_write_binary(&rsacontext.E, dataE, lenE);

	//get D
	u1 dataD[2048] = {0};
	u4 lenD=2048;
	lenD = mpi_size(&rsacontext.D);
	memset(dataD, 0x00, sizeof(dataD));
	mpi_write_binary(&rsacontext.D, dataD, lenD);

	//get P
	u1 dataP[2048] = {0};
	u4 lenP=2048;
	lenP = mpi_size(&rsacontext.P);
	memset(dataP, 0x00, sizeof(dataP));
	mpi_write_binary(&rsacontext.P, dataP, lenP);

	//get Q
	u1 dataQ[2048] = {0};
	u4 lenQ=2048;
	lenQ = mpi_size(&rsacontext.Q);
	memset(dataQ, 0x00, sizeof(dataQ));
	mpi_write_binary(&rsacontext.Q, dataQ, lenQ);

	//get DP
	u1 dataDP[2048] = {0};
	u4 lenDP=2048;
	lenDP = mpi_size(&rsacontext.DP);
	memset(dataDP, 0x00, sizeof(dataDP));
	mpi_write_binary(&rsacontext.DP, dataDP, lenDP);

	//get DQ
	u1 dataDQ[2048] = {0};
	u4 lenDQ=2048;
	len = mpi_size(&rsacontext.DQ);
	memset(dataDQ, 0x00, sizeof(dataDQ));
	mpi_write_binary(&rsacontext.DQ, dataDQ, lenDQ);

	//get Qinv
	u1 dataQP[2048] = {0};
	u4 lenQP=2048;
	lenQP = mpi_size(&rsacontext.QP);
	memset(dataQP, 0x00, sizeof(dataQP));
	mpi_write_binary(&rsacontext.QP, dataQP, lenQP);


	/********************************************************************************************************/
	//Create RSA Public key
	/********************************************************************************************************/
	testBase.CreateObject_rsaPub(dataN, lenN, dataE, lenE);
	CK_OBJECT_HANDLE rsaPubHandle = testBase.GetRsaPubKeyHandle();


	/********************************************************************************************************/
	//Create AES key
	/********************************************************************************************************/
	testBase.GenerateKey_AES();
	CK_OBJECT_HANDLE aesHandle = testBase.GetAesKeyHandle();


	/********************************************************************************************************/
	//wrap AES key
	/********************************************************************************************************/
	CK_BYTE wrappedKey[1024] = {0};
	CK_ULONG ulWrappedKeyLen = 1024;

	rv = testBase.RsaWrapAes(rsaPubHandle, aesHandle, wrappedKey, &ulWrappedKeyLen);

	if (CKR_OK != rv)
	{
		testBase.Finalize();
		return rv;
	}
	//
	//...................................................................
	//here,  the private key(pkcs8 format) in file keyfile.key will be encryptd by the AES key
	//in fact,the private key will be generate by Encryption machine

	CK_BYTE wrappedPri[3096] = {0};
	CK_ULONG wrappedPriLen = 3096;

	CK_BYTE plainPri[3096] = {0};
	CK_ULONG plainPriLen = PRIVATE_FILE_LEN;


	FILE* file; 
	file = fopen(".\\keyfile.key", "rb"); 
	int lenf = fread(plainPri, PRIVATE_FILE_LEN, 1, file); 
	fclose(file);

	testBase.EncrptPkcs8RsaPrivate(aesHandle, plainPri, plainPriLen, wrappedPri, &wrappedPriLen);

	/********************************************************************************************************/
	//unwrap ,then create RSA private key
	/********************************************************************************************************/

	CK_OBJECT_HANDLE hPrivateHandle;
	testBase.AesUnWrapRsa(aesHandle, &wrappedPri[0], wrappedPriLen,  &hPrivateHandle,&dataN[0], lenN, &dataE[0], lenE, &dataD[0], lenD, &dataP[0], lenP, &dataQ[0], lenQ, &dataDP[0],lenDP, &dataDQ[0],lenDQ, &dataQP[0], lenQP);


	//sign test
	testBase.SignTest(hPrivateHandle);

	/********************************************************************************************************/
	//clean
	/********************************************************************************************************/
	testBase.Finalize();


	printf("\n\nTest finished.\n\nPress any key to exit ...\n");
	getch();

	return 0;
}



